//
//  AppDelegate.swift
//  Kalkulator Stromverbrauch
//
//  Created by Thomas Kaltschmidt on 29.08.14.
//  Copyright (c) 2014 Mac & i. All rights reserved.
//

import Cocoa

class AppDelegate: NSObject, NSApplicationDelegate {
                            
    @IBOutlet weak var window: NSWindow!
    
    @IBOutlet weak var geraeteFeld: NSComboBox!
    @IBOutlet weak var verbrauchsFeld: NSTextField!
    
    @IBOutlet weak var taeglicheNutzungFeld: NSTextField!
    
    @IBOutlet weak var wochenNutzungSchalter: NSMatrix!
    @IBOutlet weak var kostenrateFeld: NSTextField!
    
    @IBOutlet weak var ausgabeView: NSScrollView!
    
    @IBOutlet var ausgabe: NSTextView!
    
    
    var wochenNutzungTage:Double=0
    
    
    func applicationDidFinishLaunching(aNotification: NSNotification?) {
        // Insert code here to initialize your application
        
        geraeteFeld.addItemsWithObjectValues(["Aquarium", "Backofen", "Boiler", "Computer", "Drucker", "Durchlauferhitzer", "Router", "Fernseher", "Fön", "Herd", "Kühlschrank", "Toaster"])
        
    }
    
    func applicationWillTerminate(aNotification: NSNotification?) {
        // Insert code here to tear down your application
    }
    
    
    
    @IBAction func hinzufügenEintrag(sender: AnyObject) {
        
        var geraet=geraeteFeld.stringValue
        
        var verbrauch=verbrauchsFeld.doubleValue
        var kostenProKwh=kostenrateFeld.doubleValue
        var taeglicheNutzung=taeglicheNutzungFeld.doubleValue
        
        
        switch (wochenNutzungSchalter.selectedRow) {
        case 0:
            wochenNutzungTage=7
        case 1:
            wochenNutzungTage=5
        case 2:
            wochenNutzungTage=2
            
        default:
            break;
        }
        
        
        var kWhProTag=(verbrauch * taeglicheNutzung) / 1000
        //var kWhProTag:Double=verbrauch * taeglicheNutzung / 1_000
        var kostenProTag=kWhProTag * kostenProKwh
        
        
        var mystring="Ihr \(geraet) verbraucht durchschnittlich:\n\n"
        mystring += "\(kalkuliereWert(menge: kWhProTag, anzTage: 1)) kWh pro Tag = \(kalkuliereWert(menge: kostenProTag, anzTage: 1)) EUR \n"
        mystring += "\(kalkuliereWert(menge: kWhProTag, anzTage: 7)) kWh pro Woche = \(kalkuliereWert(menge: kostenProTag, anzTage: 7)) EUR \n"
        mystring += "\(kalkuliereWert(menge: kWhProTag, anzTage: 30)) kWh pro Monat = \(kalkuliereWert(menge: kostenProTag, anzTage: 30)) EUR \n"
        mystring += "\(kalkuliereWert(menge: kWhProTag, anzTage: 364)) kWh pro Jahr = \(kalkuliereWert(menge: kostenProTag, anzTage: 364)) EUR \n\n"
        
        
        var formatierteInfo=NSMutableAttributedString(string:mystring)
        
        let mystorage=ausgabe.textStorage
        
        mystorage.appendAttributedString(formatierteInfo)
        
        ausgabe.scrollRangeToVisible(NSRange(location: mystorage.length, length: 0))
    }
    
    
    @IBAction func löschenReport(sender: AnyObject) {
    }
    
    
    @IBAction func speichernReport(sender: AnyObject) {
    }
    
    
    
    func kalkuliereWert(#menge: Double, anzTage: Double) -> (Double){
        
        if anzTage == 1 {
            let ergebnis=menge * anzTage
            return (ergebnis)
            
        } else {
            
            let ergebnis=menge * anzTage * (wochenNutzungTage / 7)
            return (ergebnis)
        }
        
        
    }
    
    

}

